
!"Pocket Smalltalk fileout - 11:52:52, zondag, 15 juli, 2001"!


!Object constantsFor: 'PalmOS Table Constants'!

checkboxTableItem 0! 
customTableItem 1! 
dateTableItem 2! 
gridBounds 48! 
gridHorDot 1! 
gridHorSolid 2! 
gridLeftRight 32! 
gridNone 0! 
gridTopBottom 16! 
gridVertDot 4! 
gridVertSolid 8! 
itemTypeHandle 3! 
itemTypeInt 1! 
itemTypePtr 2! 
labelTableItem 3! 
myCalculate 16384! 
myDate 514! 
myDateEdit 770! 
myDateLong 1537! 
myDateLongEdit 1793! 
myFraction 2561! 
myFractionEdit 2822! 
myInitialize 32768! 
myNumeric 2049! 
myNumericEdit 2310! 
myTime 1025! 
myTimeEdit 1281! 
numericTableItem 4! 
popupTriggerTableItem 5! 
textTableItem 6! 
textWithNoteTableItem 7! 
timeTableItem 8! !

FormObject subclass: #Table
	instanceVariableNames: 'numRows numColumns itemType resizeColumn resizePosition grid sibling firstSibling secondSibling usableColumns '
	classVariableNames: ''!

!Table methodsFor: 'utility'!

handleFieldHeightChangedEvent

	self drawGrid: grid.!

resetSelection
	| rect |

	rect := CRectangle buffer.
	((SYSTRAP TblGetSelection: pointer rowP: PadBuffer columnP: (PadBuffer offsetBy: 2)) asBoolean)
		ifTrue: [ 	SYSTRAP TblGetItemBounds: pointer row: (PadBuffer wordAt: 0) column: (PadBuffer wordAt: 2) r: (rect pointer).
			SYSTRAP WinInvertRectangle: (rect pointer) cornerDiam: 0 ].
!

getSelection
	| result |

	result := (SYSTRAP TblGetSelection: pointer rowP: PadBuffer columnP: (PadBuffer offsetBy: 2)) asBoolean.
	result ifTrue: [
		^Point x: (PadBuffer wordAt: 0) y: (PadBuffer wordAt: 2).
	].
	^nil.
!

redrawGrid
	self drawGrid: grid.!

releaseFocus

	SYSTRAP TblReleaseFocus: pointer!

startResize: position
	| rect rectangle left top right bottom width |
	
	rect := CRectangle buffer.
	SYSTRAP TblGetBounds: pointer rectangle: (rect pointer).
	rectangle := rect asSmalltalkRectangle.
	
	left := rectangle left.
	top := rectangle top. 
	right := left + rectangle width.
	bottom := top + rectangle height.
	width := left.

	0 to: (numColumns - 1) do:					"can also resize the last column"
		[ :j | 
			(self columnUsable: j) ifTrue: [
		      		width := width + (SYSTRAP TblGetColumnWidth: pointer column: j).
		      		(position x > (width - 2) and: [ position x < (width + 2) ] )
		      			ifTrue: [ resizeColumn := j.
		      	            		resizePosition := width.
					   	sibling ifNotNil: [ sibling drawGrid: 24 ].
		      	            		^true ].
		      		 width := width + 1.
		      	 ].
		].
		
	^false.!

redrawRow: row

	SYSTRAP TblMarkRowInvalid: pointer row: row.
	SYSTRAP TblRedrawTable: pointer.
	self resetSelection.
	self redrawGrid.
!

doResize: position
	| delta widthLeft widthRight rect |
	
	delta := position x - resizePosition.
	delta = 0
		ifTrue: [ ^false ].
	resizePosition := position x.
	widthLeft := SYSTRAP TblGetColumnWidth: pointer column: resizeColumn.
	delta < 0
		ifTrue: [ delta := -1 * ((-1 * delta) min: widthLeft) ].
	delta > 0
		ifTrue: [ delta := delta min: 160 ].
		
	SYSTRAP TblSetColumnWidth: pointer column: resizeColumn width: widthLeft + delta.
	sibling ifNotNil: [ SYSTRAP TblSetColumnWidth: sibling pointer column: resizeColumn width: widthLeft + delta ].

	self redraw.
	sibling ifNotNil: [ sibling redraw ].
	!

grabFocusRow: row column: column

	SYSTRAP TblGrabFocus: pointer row: row column: column.
!

redraw
	| rect |
	
	rect := CRectangle buffer.
	SYSTRAP TblGetBounds: pointer rectangle: (rect pointer).
	SYSTRAP WinSetClip: rect pointer.
	SYSTRAP TblMarkTableInvalid: pointer.
	SYSTRAP TblRedrawTable: pointer.
	self resetSelection.
	self drawGrid: grid.
	Window clearClip.

!

drawGrid: style
	| rect rectangle left top right bottom height newtop newleft |
	
	"style:	0	no grid				##gridNone
		1	horizontal lines dotted		##gridHorDot
		2	horizontal lines solid		##gridHorSolid
		4	vertical lines dotted		##gridVertDot
		8	vertical lines solid		##gridVertSolid
		16	bounds top bottom (solid)	##gridTopBottom
		32	bounds left right (solid)		##gridLeftRight
		48	bounds (solid)			##gridBounds
		
		these values can be added together.
		drawGrid needs to be called only once, table itself will redraw when neccesary"
	
	style ifNil: [ ^false ].
	style = 0
		ifTrue: [ ^false ].
	grid ifNil: [ grid := style ].
	
	rect := CRectangle buffer.
	SYSTRAP TblGetBounds: pointer rectangle: (rect pointer).

	rectangle := rect asSmalltalkRectangle.
	left := rectangle left.
	top := rectangle top. 
	right := left + rectangle width.
	bottom := top + rectangle height.

	((style bitAnd: 32) = 32)					"bounds left right"
		ifTrue: [ Window setClipX: left - 1 y: top - 1 width: right - left + 3 height: bottom - top + 2 ]
		ifFalse: [ Window setClipX: left y: top - 1 width: right - left height: bottom - top + 2 ].
		       		       
	(((style bitAnd: 1) = 1) or: [ (style bitAnd: 2) = 2 ])		"horizontal lines"
		ifTrue: [ 	newtop := top.
			0 to: (numRows - 1) do: 
				[ :i | (self rowUsable: i) = 0			"row usable"
				       	ifFalse: [newtop := newtop + (SYSTRAP TblGetRowHeight: pointer row: i).
				       	        ((style bitAnd: 1) = 1)
				       			ifTrue: [SYSTRAP WinDrawGrayLine: left y1: 
				       								newtop  x2: right y2: newtop]
				       			ifFalse: [SYSTRAP WinDrawLine: left y1: 
				       								newtop  x2: right y2: newtop].
				       	].
				].
			].

	(((style bitAnd: 4) = 4) or: [ ((style bitAnd: 8) = 8) ])		"vertical lines"
		ifTrue: [ 	newleft := left.
			0 to: (numColumns - 1) do: 
				[ :j | 
				    (self columnUsable: j) ifTrue: [
		       		       		  newleft := newleft + (SYSTRAP TblGetColumnWidth: pointer column: j).
				       		  newleft < right			"don't draw the line if on the right side" 
				       		  	ifTrue: [ ((style bitAnd: 4) = 4)
				       				ifTrue: [SYSTRAP WinDrawGrayLine: newleft 
				       								y1: top x2: newleft y2: bottom ]
				       				ifFalse: [SYSTRAP WinDrawLine: newleft 
				       								y1: top x2: newleft y2: bottom ]. 
				       			          ].
				       		  newleft := newleft + 1.
				     ].
				 ].

			].
	 
	((style bitAnd: 16) = 16)					"bounds top bottom"
		ifTrue: [SYSTRAP WinDrawLine: left  y1: top - 1 x2: right y2: top - 1.
			SYSTRAP WinDrawLine: left  y1: bottom x2: right y2: bottom ].

	((style bitAnd: 32) = 32)					"bounds left right"
		ifTrue: [SYSTRAP WinDrawLine: left - 1 y1: top - 1 x2: left - 1 y2: bottom.
			SYSTRAP WinDrawLine: right + 1 y1: top - 1 x2: right + 1 y2: bottom ].

	Window clearClip.
	^true.
! !


!Table methodsFor: 'predicates'!

usesModel
	^false.! !


!Table methodsFor: 'accessing'!

itemFntRow: row col: col put: font
	SYSTRAP TblSetItemFont: pointer row: row column: col font: (font bitShift: 8).
"	
	| value ptr |

	itemFntRow: row col: col put: font.
       	value := pointer dwordAt: (30).
       	ptr := CPointer value: value.
       	ptr byteAt: (( row * numColumns + col) * 8 + 1) put: font.
"
!

column: col width: width
	SYSTRAP TblSetColumnWidth: pointer column: col width: width. !

row: row selectable: value
	SYSTRAP TblSetRowSelectable: pointer row: row selectable: (value asInteger bitShift: 8).
!

row: row usable: value
	SYSTRAP TblSetRowUsable: pointer row: row usable: (value asInteger bitShift: 8).!

unHighlightSelection
	SYSTRAP TblUnhighlightSelection: pointer.!

columnWidth: col
	^SYSTRAP TblGetColumnWidth:pointer column: col.!

column: col usable: value
	usableColumns at: (col + 1) put: value.
	SYSTRAP TblSetColumnUsable: pointer col: col usable: (value asInteger bitShift: 8).!

row: row height: height
	SYSTRAP TblSetRowHeight: pointer row: row height: height. 
!

idForRow: row put: id
	SYSTRAP TblSetRowID: pointer row: row id: id.
	^id.!

idForRow: row
	^SYSTRAP TblGetRowID: pointer row: row
!

sibling: asibling
	"the sibling gets there columns resized in sync with the columns of this table"
	"you can cascade tables by setting the subling of the sibling"
	sibling := asibling!

numRows
	^numRows!

numColumns
	^numColumns!

itemRow: row col: col
	| type ptr handle text |
	
	type := itemType at: (row * numColumns + col + 1).
	
	type = ##itemTypeInt
		ifTrue: [ ^SYSTRAP TblGetItemInt: pointer row: row column: col ].
	type = ##itemTypeHandle
		ifTrue: [ handle := self primTable: pointer getItemPtrRow: row col: col.
			ptr := handle lock.
			text := ptr extractCString.
			handle unlock.
			^text ].
	type = ##itemTypePtr
		ifTrue: [ ptr := self primTable: pointer getItemPtrRow: row col: col.
			^ptr extractCString ].
	^nil.
!

isEditing
	| result |
	
	result := SYSTRAP TblEditing: pointer.
	result = 0
		ifTrue: [ ^false ].
	^true!

rowUsable: row
	^SYSTRAP TblRowUsable: pointer row: row.!

columnUsable: col
	^usableColumns at: (col + 1).!

reverseRow: row
	| r r1 r2 r3 |

	r := CRectangle	buffer.
	SYSTRAP TblGetBounds: pointer rect: r pointer.
	r1 := r asSmalltalkRectangle.
	SYSTRAP TblGetItemBounds: pointer row: row column: 0 rect: r pointer.
	r2 := r asSmalltalkRectangle.
	r2 corner: r1 right @ r2 bottom.
	Window invertRectangle: r2.
	
!

releaseDynamicMemory
	| type ptr ptr2 |
	
	0 to: numRows - 1 do: [ :row |
		0 to: numColumns - 1 do: [ :col |
			type := itemType at: (row * numColumns + col + 1).
	
			type = ##itemTypePtr
				ifTrue: [ ptr := self primTable: pointer getItemPtrRow: row col: col.
					SYSTRAP TblSetItemPtr: pointer row: row column: col pointer: CPointer null. 
					ptr isNull ifFalse: [ ptr free. ].
			 		].						
			type = ##itemTypeHandle
				ifTrue: [ ptr := self primTable: pointer getItemPtrRow: row col: col.
					SYSTRAP TblSetItemPtr: pointer row: row column: col pointer: CPointer null. 
					ptr isNull ifFalse: [ ptr freeHandle. ].
					].
			].
		].
!

height
	| rect rectangle |
	rect := CRectangle buffer.
	SYSTRAP TblGetBounds: pointer rectangle: (rect pointer).

	rectangle := rect asSmalltalkRectangle.
	^rectangle height.
!

rowHeight: row

	^SYSTRAP TblGetRowHeight: pointer row: row. 
!

selectItemRow: row col: column
	SYSTRAP TblSelectItem: pointer row: row column: column.!

itemRow: row col: col put: value
	| type ptr ptr2  |
	
	type := itemType at: (row * numColumns + col + 1).
	
	type = ##itemTypeInt
		ifTrue: [ SYSTRAP TblSetItemInt: pointer row: row column: col integer: value.
			^value ].
	type = ##itemTypePtr
		ifTrue: [ ptr := self primTable: pointer getItemPtrRow: row col: col.		
			" old	
			ptr2 := self primTable: pointer getItemPtrRow: row + 1 col: col.			
			ptr isNull ifFalse: [ ptr = ptr2 ifFalse: [ ptr free ]. ].			
			"
			SYSTRAP TblSetItemPtr: pointer row: row column: col pointer: value copyToHeap. 
			ptr isNull ifFalse: [ ptr free. ].			
			^value ].								
	type = ##itemTypeHandle
		ifTrue: [ ptr := self primTable: pointer getItemPtrRow: row col: col.
			" old
			ptr2 := self primTable: pointer getItemPtrRow: row + 1 col: col.
			ptr isNull ifFalse: [ ptr = ptr2 ifFalse: [ ptr freeHandle ]. ].
			"
			SYSTRAP TblSetItemPtr: pointer row: row column: col pointer: value copyToHandle.
			ptr isNull ifFalse: [ ptr freeHandle. ].
			^value ].
	^nil!

itemStyleRow: row col: col put: value
	| style basicvalue |
	
	SYSTRAP TblSetItemStyle: pointer row: row column: col type: (value bitShift: 8).
	basicvalue := value bitAnd: 16r00FF.

	style := ##itemTypeInt.				"default"
	basicvalue = ##customTableItem
		ifTrue: [ style := ##itemTypePtr ].
	basicvalue = ##labelTableItem
		ifTrue: [ style := ##itemTypePtr ].
	basicvalue = ##textTableItem
		ifTrue: [ style := ##itemTypeHandle ].
	basicvalue = ##textWithNoteTableItem
		ifTrue: [ style := ##itemTypeHandle ].
		
	itemType at: (row * numColumns + col + 1) put: style.
!

lastUsableRow

	^SYSTRAP TblGetLastUsableRow: pointer.!

dataForRow: row

	^SYSTRAP TblGetRowData: pointer row: row
!

dataForRow: row put: data

	SYSTRAP TblSetRowData: pointer row: row data: data.
	^data.! !


!Table methodsFor: 'initialization'!

acquireModel
	super acquireModel.
	self primInitTable: pointer.
	numRows := SYSTRAP TblGetNumberOfRows: pointer.
	numColumns := (pointer wordAt: 12) asInteger.
	usableColumns := Array new: numColumns.
	usableColumns atAllPut: false.
	itemType := Array new: (numRows * numColumns).
! !


!Table methodsFor: 'private'!

primInitTable: ptr
	<primitive: 102>
	^self primitiveFailed.
!

primTable: ptr getItemPtrRow: row col: col
	<primitive: 103>
	^self primitiveFailed.
	 ! !


!CPointer class methodsFor: 'instance creation'!

value: value
	| ptr |
	"creates a pointer which points to the adress given by value"
	ptr := self new.
	5 - value basicSize to: 4 do: [ :i | ptr basicAt: i put: (value basicAt: i) ].
	^ptr.! !

!String methodsFor: 'copying'!

copyToHandle
	| handle ptr |
	handle := CPointer allocateMovableChunk: self basicSize + 1.
	ptr := handle lock.
	SYSTRAP MemMove: ptr from: self length: self basicSize.
	ptr byteAt: self basicSize put: 0.
	handle unlock.
	^handle.
! !
